#include <amxmodx>
#include <umitem>
#include <engine>
#include <fakemeta>

#define LONGJUMP_POWER	750

new PLUGIN_NAME[] 	= "UM Item: Long Jump"
new PLUGIN_AUTHOR[] 	= "Cheap_Suit"
new PLUGIN_VERSION[] 	= "1.1"

new bool:g_LongJump[33]
new bool:g_Jumped[33]
public plugin_init() 
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	register_item("Long Jump", "Long jump from HL", 1000)
}

public client_connect(id) {
	g_LongJump[id] = false
}

public Enable_Item(id) {
	g_LongJump[id] = true
}

public Disable_Item(id) {
	g_LongJump[id] = false
}

public client_PreThink(id)
{
	if(!is_user_connected(id) || !is_user_alive(id)) {
		return PLUGIN_CONTINUE
	}
	
	if(!g_LongJump[id]) {
		return PLUGIN_CONTINUE
	}
	
	new Button = get_user_button(id)
	new oButton = get_user_oldbutton(id)
	if(Button & IN_JUMP && Button & IN_DUCK)
	{
		if(g_Jumped[id]) {
			return PLUGIN_CONTINUE
		}
		
		new Flags = entity_get_int(id, EV_INT_flags)
		if(Flags | FL_WATERJUMP && entity_get_int(id, EV_INT_waterlevel) < 2 && Flags & FL_ONGROUND)
		{
			new Float:fVelocity[3]
			entity_get_vector(id, EV_VEC_velocity, fVelocity)
			
			new Float:vAngle[3]
			entity_get_vector(id, EV_VEC_angles, vAngle)
			engfunc(EngFunc_MakeVectors, vAngle)
			
			new Float:vForward[3]
			get_global_vector(GL_v_forward, vForward)
			
			if(fVelocity[0] == 0.0 || fVelocity[1] == 0.0) {
				return PLUGIN_CONTINUE
			}
			
			fVelocity[0] = vForward[0] * LONGJUMP_POWER
			fVelocity[1] = vForward[1] * LONGJUMP_POWER
			fVelocity[2] = 310.0
			
			entity_set_vector(id, EV_VEC_velocity, fVelocity)
			g_Jumped[id] = true
		}
	} else if(oButton & IN_JUMP || oButton & IN_DUCK) {
		g_Jumped[id] = false
	}
	return PLUGIN_CONTINUE
}
		
		
		
